﻿; !!! Set Compiler/Compiler Options... Library Subsystem: DirectX9 !!!



; ------------------------------------------------------------
;   PureBasic - Plasma 10 seconds benchmark
; ------------------------------------------------------------

EnableExplicit

InitSprite()

Define i, counter = 0, time
Global Dim cols(2,255)
#x_size = 1280-1
#y_size = 720-1

For i=0 To 255
  cols(0, i) = Abs(128-127 * Sin(i*#PI/32))
  cols(1, i) = Abs(128-127 * Sin(i*#PI/64))
  cols(2, i) = Abs(128-127 * Sin(i*#PI/128))
Next

Procedure Paint()
  Protected x2.f, y2.f
  Protected y, x ,c
  StartDrawing(SpriteOutput(0))
    x2 = Random(35,20)
    y2 = Random(28,8)
    For y = 1 To #y_size
      For x = 1 To #x_size
        c = Sin(x/x2)*128 + Sin(y/y2)*32 + Sin((x+y)/16)*64
        c & 255
        Plot(x, y, RGB(cols(0,c), cols(1,c), cols(2,c)))
      Next
    Next
  StopDrawing()
  DisplaySprite(0,0,0)
  FlipBuffers()
EndProcedure

OpenWindow(0, 0, 0, #x_size+1, #y_size+1, "Plasma 10 seconds benchmark", #PB_Window_ScreenCentered)
OpenWindowedScreen(WindowID(0), 0, 0, #x_size+1, #y_size+1, 0, 0, 0, 0)
CreateSprite(0, #x_size+1, #y_size+1)
While WindowEvent() : Wend

time = ElapsedMilliseconds() + 10000
Repeat
  WindowEvent()
  Paint()
  counter + 1
Until ElapsedMilliseconds() > time

SetWindowTitle(0, "Plasma 10 seconds benchmark - " + counter)
Delay (2000)

; IDE Options = PureBasic 6.00 LTS (Windows - x64)
; CursorPosition = 10
; Folding = -
; Optimizer
; EnableXP
; EnableUser
; Executable = 
; SubSystem = DirectX9
; DisableDebugger
; Compiler = PureBasic 6.00 LTS - C Backend (Windows - x64)
; EnablePurifier